#pragma once

#include <string.h>

#define BIT2BYTE(bitsize) (((bitsize+7)&~7) >> 3)

template <int BITSIZE>
class CStaticBitString {
public:
	void	Clear();
	void	Set(int bit);
	void	Reset(int bit);
	int		Test(int bit);
	char*	GetData();

private:
	unsigned char data[BIT2BYTE(BITSIZE)];
};

template <int BITSIZE>
inline void CStaticBitString<BITSIZE>::Clear() {
	memset(data, 0, size+1);
}

template <int BITSIZE>
inline void CStaticBitString<BITSIZE>::Set(int bit) {
	data[bit>>3] |= 1<<(bit&7);
}

template <int BITSIZE>
inline void CStaticBitString<BITSIZE>::Reset(int bit) {
	data[bit>>3] &= ~(1<<(bit&7));
}

template <int BITSIZE>
inline int CStaticBitString<BITSIZE>::Test(int bit) {
	return (data[bit>>3] & 1<<(bit&7));
}

template <int BITSIZE>
inline char* CStaticBitString<BITSIZE>::GetData() {
	return data;
}

// No bounds checking
class CBitString {
public:
			CBitString();
			~CBitString();
	void	Init(int bitsize);
	void	Clear();
	void	Set(int bit);
	void	SetCond(int bit, bool oneOrZero);
	void	Reset(int bit);
	int		Test(int bit);
	void	BitAND(CBitString *bs);
	unsigned char*
			GetData();
	void	Swap(CBitString *bs);
	void	SetData(void* data);
private:
	unsigned char *data;
	int		byteSize;
};

inline CBitString::CBitString():data(0),byteSize(0) {};

inline CBitString::~CBitString() {
	delete [] data;
};

inline void CBitString::Init(int bitsize) {
	//byteSize = (bitsize>>3) + (int)((bool)(bitsize&7));
	byteSize = ((bitsize+7)&~7) >> 3;
	data = new unsigned char [byteSize];
	memset(data, 0, byteSize);
}

inline void CBitString::Clear() {
	memset(data, 0, byteSize);
}

inline void CBitString::Set(int bit) {
	data[bit>>3] |= 1<<(bit&7);
}

inline void CBitString::SetCond(int bit, bool oneOrZero) {
	data[bit>>3] |= ((int)oneOrZero)<<(bit&7);
}

inline void CBitString::Reset(int bit) {
	data[bit>>3] &= ~(1<<(bit&7));
}

inline int CBitString::Test(int bit) {
	return (data[bit>>3] & 1<<(bit&7));
}

inline unsigned char* CBitString::GetData() {
	return data;
}

inline void	CBitString::Swap(CBitString *bs) {
	unsigned char *t = data;
	data = bs->data;
	bs->data = t;

	int b = byteSize;
	byteSize = bs->byteSize;
	bs->byteSize = b;
}

inline void CBitString::BitAND(CBitString *bs) {
	for(int i=0; i<byteSize; i++)
		data[i] &= bs->data[i];
}

inline void CBitString::SetData(void* cdata) {
	memcpy(data, cdata, byteSize);
}