#include "gamesys.h"

#include "brush.h"
#include "lexer.h"
#include "math.h"
#include "shader.h"

void CMapBrushSide::SetPlane(vec4 p[]) {
	sPlane plane;
	vec4 v1 = p[1] - p[0];
	vec4 v2 = p[2] - p[0];
	plane = v1.cross3D(v2);
	plane.normalize();
	plane.w = -plane.dot(p[0]);

	SetPlane(plane);
}

vec4 CMapBrushSide::TransformTexCoord(vec4& w_pos) {
	vec4 r;
	r.x = tex_matrix[0].dot(w_pos);
	r.y = tex_matrix[1].dot(w_pos);
	// normalize
	r.x /= (float)GetShader()->textureWidth;
	r.y /= (float)GetShader()->textureHeight;
	return r;
}

void CMapBrushSide::SetTexMatrix(TexVecs &t) {
	vec4 sincos;
	vec4 abs_plane = fabs4(GetPlane());
	int	is = 0;
	int it = 1;

	if(t.rot == 0.0f) {
		sincos.x = 0.0f;
		sincos.y = 1.0f;
	} else {
		sincos = SinCos_360(t.rot);
	}

	if(abs_plane.x > abs_plane.y && abs_plane.x > abs_plane.z) {
		is++;
		it++;
	} else if(abs_plane.y > abs_plane.z && abs_plane.y > abs_plane.x)
		it++;

	// invert scales
	if(t.scale[0] == 0.0f)
		t.scale[0] = 1.0f;
	else
		t.scale[0] = 1.0f / t.scale[0];

	if(t.scale[1] == 0.0f)
		t.scale[1] = 1.0f;
	else
		t.scale[1] = 1.0f / t.scale[1];

	tex_matrix[0].clear();
	tex_matrix[0][is] = sincos.y * t.scale[0];
	tex_matrix[0][it] = sincos.x * t.scale[0];
	tex_matrix[0][ 3] = t.offset[0];
	tex_matrix[1].clear();
	tex_matrix[1][is] = -sincos.x  * t.scale[1];
	tex_matrix[1][it] = sincos.y  * t.scale[1];
	tex_matrix[1][ 3] = t.offset[1];
}

int	CMapBrush::Parse() {
	CLexer *lex = g_curMap->GetLex();

	while(lex->PeekToken() == "(") {
		vec4			p[3];
		TexVecs			tv;
		CMapBrushSide	&side = sides.TailAlloc();
		CMapShader		shader;

		for(int i=0; i<3; i++) {
			lex->ReadMatrix1D(p[i].data, 3);
			p[i].w = 1.0f;
		}

		side.SetPlane(p);
		
		shader.Load(lex->GetToken());

		tv.offset[0] = lex->ReadFloat();
		tv.offset[1] = lex->ReadFloat();
		tv.rot = lex->ReadFloat();
		tv.scale[0] = lex->ReadFloat();
		tv.scale[1] = lex->ReadFloat();

		side.SetTexMatrix(tv);

		// Not sure about those 2
		shader.surfaceFlags |= lex->ReadInt();
		shader.contentFlags |= lex->ReadInt();

		lex->ReadRestOfLine();

		side.SetShader(shader);
	}

	return sides.GetNum();
}
