#pragma once

#include "map.h"
#include "memalloc.h"
#include "math.h"
#include "winding.h"
#include "vectoraligned.h"
#include "vector.h"
#include "string.h"

#include "bspdata.h"
#include "surfaceflags.h"

struct TexVecs {
	float offset[2];
	float rot;
	float scale[2];
};	

class CMapBrushSide : public CMemObj {
friend class CMapBrush;
public:
				CMapBrushSide();
				CMapBrushSide(CMapBrushSide* b);
				CMapBrushSide(vec4 points[3]);

	void		SetPlane(vec4 &plane);
	void		SetPlane(vec4 points[3]);
	void		SetShader(CMapShader &s);
	void		SetTexMatrix(TexVecs &t);
	vec4		TransformTexCoord(vec4& w_pos);
	int			GetIPlane();
	sPlane*		GetPlane();
	CMapShader*	GetShader();

private:
	vec4		tex_matrix[2];
	int			iplane;
	int			ishader;
};

inline CMapBrushSide::CMapBrushSide() {
}

inline CMapBrushSide::CMapBrushSide(CMapBrushSide* b):
ishader(b->ishader), iplane(b->iplane) {
	tex_matrix[0] = b->tex_matrix[0];
	tex_matrix[1] = b->tex_matrix[1];
}

inline CMapBrushSide::CMapBrushSide(vec4 points[3]) {
	SetPlane(points);
}

inline void CMapBrushSide::SetShader(CMapShader &s) {
	ishader = g_curMap->AddShader(s);
}

inline void	CMapBrushSide::SetPlane(vec4 &plane) {
	iplane = g_curMap->AddPlane(plane);
}

inline sPlane* CMapBrushSide::GetPlane() {
	return g_curMap->GetPlane(iplane);
}

inline CMapShader* CMapBrushSide::GetShader() {
	return g_curMap->GetShader(ishader);
}

inline int CMapBrushSide::GetIPlane() {
	return iplane;
}

class CMapBrush {
public:
			CMapBrush();
			~CMapBrush();
	int		Parse();

	CAlignedVec<CMapBrushSide>	sides;
};

inline CMapBrush::CMapBrush() {
	sides.Reserve(6);
}

inline CMapBrush::~CMapBrush() {
	sides.Clear();
}
