#pragma once
#include "math.h"
#include "hashtablevec.h"
#include "string.h"
#include "bspdata.h"
#include "surfaceflags.h"
#include "shader.h"

class CBSP {
public:
	bool	TraceRay(vec4 *start, vec4 *end);

	void	Save(char *filename);
	bool	Load(char *filename);

	CVecHash<CMapShader>	shadersHash;
	CVecHash<sPlane>		planesHash;

	CVector<sBSPShader>		shaders;
	CAlignedVec<sPlane>		planes;
	CVector<sBSPLeaf>		leafs;
	CVector<sBSPNode>		nodes;
	CVector<sBSPBrush>		brushes;
	CVector<sBSPBrushSide>	brushSides;

	CVector<int>			leafSurfIndex;
	CVector<int>			leafBrushIndex;
	CVector<sBSPModel>		models;

	CVector<sBSPVertex>		vertices;
	CVector<sBSPSurface>	surfaces;

	CVector<int>			visibility;
	
	CVector<sBSPColor>		lightMaps;
	CVector<sBSPColor>		lightGrid;

	CString					entities;
	CVector<sBSPFog>		fogs;

	CVector<int>			vertexIndicies;
};