#include "bspconv.h"
#include "bspbrush.h"

void CBSPFilter::FilterBrushesAndMarkOpaqueNodes(_CBSPTree *tree) {
	int n = tree->brushes.GetNum();
	int nLeafs = 0;

	for(int i=0; i<n; i++) {
		nLeafs += tree->brushes[i]->FilterBrushAndMarkOpaqueNodes(tree);
	}

	g_CLog.Log(LOG_SYSTEM, "%4d leafs marked opaque.", nLeafs);
}

bool CBSPFilter::FilterFacesAndMarkLeaves(_CBSPTree *tree, bool doFilter) {
	int n = tree->faces.GetNum();
	int nFaces = 0;

	for(int i=0; i<n; i++) {

		tree->faces[i]->AddFaceRefencesToNodes(tree, doFilter);

		if(!tree->faces[i]->winding.Empty()) {
			nFaces++;
		}
	}

	g_CLog.Log(LOG_SYSTEM, "%4d faces visible.", nFaces);

	return nFaces > 0;
}