#pragma once

#include "bspconv.h"

class CBSPBuilder : public IBSPTreeVisitor {
public:
	// visitor interface
	void			VisitNodeBegin(_CBSPSplitNode *n);
	void			VisitNodeEnd(_CBSPSplitNode *n) {};
	void			VisitLeaf(_CBSPLeafNode *l) {};

	// public interface
	bool			BuildTree(_CBSPTree *tree);
	void			RebuildTree();
private:
	void			InitTree();
	void			CalcInitialTreeBounds();
	void			CreateSplitNode(_CBSPSplitNode *n);
	void			PickSplitPlane(_CBSPSplitNode *n);
	bool			ExtractMapData();

	_CBSPTree*		tree;
	CVector<_CBSPFace>	faces;	// temporary
	int				nLeafs;
};

inline void	CBSPBuilder::VisitNodeBegin(_CBSPSplitNode *n) {
	CreateSplitNode(n);
}

class CBSPReachableExtractor : public IBSPTreeVisitor {
public:
	// visitor interface
	void			VisitNodeBegin(_CBSPSplitNode *n) {};
	void			VisitNodeEnd(_CBSPSplitNode *n);
	void			VisitLeaf(_CBSPLeafNode *l);

	void			ExtractReachableAndDeallocate(_CBSPTree *old_tree);
private:

	_CBSPTree*				tree;
	CVector<_CBSPBrush*>	brushes;
	CVector<_CBSPFace*>		faces;
};

inline void CBSPReachableExtractor::VisitNodeEnd(_CBSPSplitNode *n) {
	delete n->children[0];
	delete n->children[1];
}