#pragma once

#include "string.h"
#include "log.h"
#include <stdio.h>


void LoadFile(CString &str, char *filename) {
	FILE *fp = fopen(filename, "rt");
	if(!fp) {
		g_CLog.Log(LOG_SYSTEM, LOG_FILE_NOT_FOUND, filename);
		return;
	}

	fseek(fp, 0, SEEK_END);
	int len = ftell(fp);
	rewind(fp);

	str.SetLen(len);
	// in Win32, cr+lf is translated to lf
	len = (int)fread(str.GetData(), 1, len, fp);
	str[len] = NULL;

	fclose(fp);
}