#pragma once

#include "string.h"
#include "hashtablevec.h"

template <class Type>
class CKeyValPair {
public:
			CKeyValPair() {}
			CKeyValPair(CString& k, Type& v):key(k, true), value(v, true) {};
	bool	operator==(CKeyValPair &kv) { 
				return key==kv.key;	}

	int			Hash() {return key.Hash();}

	CString		key;
	Type		value;
};

class CDict : public CVecHash<CKeyValPair<CString> > {
public:
	void		Add(CString &key, CString &value);
	CString*	Get(CString &key);
};

// if key exists with different value, the previous value is overwritten
inline void	CDict::Add(CString &key, CString &value) {
	int h = key.Hash() & VEC_HASH_BASE;
	int i = hash[h];
	while(i >= 0 && !(data[i].key == key))
		i = next_data[i];

	if(i >= 0) {
		if(!(data[i].value == value))
			data[i].value = value;
	}

	int cur_pos = data.TailAlloc(1);
	data[cur_pos].key = key;
	data[cur_pos].value = value;

	next_data.Append(hash[h]);
	hash[h] = cur_pos;
}

// returns the value associated with key
inline CString* CDict::Get(CString &key) {
	int h = key.Hash() & VEC_HASH_BASE;
	int i = hash[h];
	while(i >= 0 && !(data[i].key == key))
		i = next_data[i];
	if(i < 0)
		return NULL;

	return &(data[i].value);
}