#pragma once
#include "gamesys.h"
#include "string.h"

// The lexer modifies the source string
// by delimiting the tokens with NULLs.

#define LEX_NULL_DELIMIT 1

enum TokenType {
	TT_WORD,
	TT_STRING,
	TT_INT,
	TT_FLOAT
};

enum LexError {
	L_OK,
	L_NONE,
	L_EOF
};


class CLexer {
public:
				CLexer();
				CLexer(char *ptr);
	void		SetPtr(char *ptr);
	CString&	GetToken();
	int			GetCurLine();
	int			ReadInt();
	float		ReadFloat();
	CString&	ReadRestOfLine();
	void		ReadMatrix1D(float *fptr, int n);
	CString&	PeekToken();
	CString&	LastToken();
	CString&	FindNext(char* str, int str_len = 1);

private:
	int			ReadWhiteSpace();

	char		*data;
	int			type;
	int			cur_pos;
	int			cur_line;
	CString		token;
	int			token_ready;
};

inline CLexer::CLexer():cur_pos(0),data(0),token(false) {}

inline CLexer::CLexer(char *ptr) {
	SetPtr(ptr);
}

inline void CLexer::SetPtr(char *ptr) {
	cur_pos = cur_line = 0;
	token_ready = 0;
	data = ptr;
}

inline CString& CLexer::LastToken() {
	return token;
}

inline int CLexer::GetCurLine() {
	return cur_line;
}