#include "log.h"

#include <stdarg.h>
#include <string.h>
#include <time.h>

#define LOG_FILE_CLIENT	"log.txt"
#define LOG_FILE_SERVER	"server_log.txt"

// Note: up to 1 argument supported
static char log_msgs[LOG_MAX_MSGS][40] = {
	"Could not open log file %s for writing.",
	"File %s not found!.",
	"File %s write error.",
	"Lex: End of file inside comment.",
	"rmapc start up."
};


CLog::CLog() {
	allowed_types = -1;

	app_log_file = fopen(LOG_FILE_CLIENT, "a");
	server_log_file = fopen(LOG_FILE_SERVER, "a");

	if(!app_log_file) {
		allowed_types &= ~(LOG_USER & LOG_APP & LOG_SYSTEM);
		Log(-1, LOG_LOG_INIT_ERROR, LOG_FILE_CLIENT);
	}
	if(!server_log_file) {
		allowed_types &= ~(LOG_SERVER);
		Log(-1, LOG_LOG_INIT_ERROR, LOG_FILE_SERVER);
	}
}

CLog::~CLog() {
	fclose(app_log_file);
	fclose(server_log_file);
}

void CLog::Log(int type, int imsg, char* arg) {
	Log(type, log_msgs[imsg], arg);
}

void CLog::Log(int type, char *msg, ...) {
	char output[256];
	time_t now = time(NULL);
	va_list args;
	va_start(args, msg);

	char* ct = ctime(&now);
	memcpy(output, ct, 24);
	output[24] = ' ';
	int size = vsnprintf(&output[25], 256-25-1, msg, args);

	if(size != -1) {
		// insert new line
		output[size + 25] = '\n';
		output[size + 26] = 0;
		size++;

	} else {
#ifdef _WIN32
		output[251] = '.';
		output[252] = '.';
		output[253] = '.';
		output[254] = '\n';
		output[255] = 0;
		size = 255 - 25;
#else
		Log(LOG_SYSTEM, "Log: Bad pointer passed\n");
		return;
#endif
	}

	// log everything to console
	fwrite(&output[25], size, 1, stdout);

	if(type & (LOG_APP | LOG_SYSTEM)) {
		fwrite(output, size + 25, 1, app_log_file);
#ifdef _DEBUG
		fflush(app_log_file);
#endif
	}

	if(type & LOG_SERVER) {
		fwrite(output, size + 25, 1, server_log_file);
#ifdef _DEBUG
		fflush(server_log_file);
#endif
	}
	va_end(args);
}

// Global logger
CLog g_CLog;
