#include "map.h"
#include "brush.h"
#include "gamesys.h"
#include "cmdlib.h"

CMapLoader *g_curMap;

bool CMapLoader::LoadMap(CString *fn) {
	filename = fn;
	g_curMap = this;

	LoadFile(src, filename->GetData());
	if(!src.Length())
		return R_FAIL;

	lex.SetPtr(src.GetData());	

	while(entities.TailAlloc().Parse()) {
	}

	// Last entity is empty
	entities.SetNum(entities.GetNum() - 1);
	return R_OK;
}


bool CMapEntity::Parse() {
	CString		token(false);
	
	CLexer*		lex = g_curMap->GetLex();

	token = lex->GetToken();
	if(token != "{") {
		if(token.GetData())
			g_CLog.Log(LOG_SYSTEM, "ParseMapEntity: Expected {, but got %s\n", lex->LastToken().GetData());
		return false;
	}

	while(1){
		token = lex->GetToken();
		if(token == "}")
			break;

		if(token == "{") { // patch or brush
			token = lex->PeekToken();
			if(token == "("){
				CMapBrush* brush = &brushes.TailAlloc();
				brush->Parse();
				
			} else {
				int cl = lex->GetCurLine();
				g_CLog.Log(LOG_SYSTEM, "ParseMapEntity: line %d, skipping unsupported entity:\n%s\n", cl, lex->FindNext("}"));
			}
			lex->FindNext("}");

		} else { // key value pair
			keyValPairs.Add(token, lex->GetToken());
		}
	}

	return true;
}

void CMapEntity::EmitKVPairs(CString *str) {
	str->Append("{\n", 2);
	for(int i=0; i<keyValPairs.GetNum(); i++) {
		str->Append('\"');
		str->Append(keyValPairs.GetElem(i)->key);
		str->Append("\" \"", 3);
		str->Append(keyValPairs.GetElem(i)->value);
		str->Append("\"\n", 2);
	}
	str->Append("}\n", 2);
}

