#include "string.h"
#include "log.h"

int CString::Hash() {
	int hash = 0;
	for(int i = 0;  i < len; i++)
		hash += (int)data[i] * (473 + i);
	return hash;
}
	

void CString::EnsureAllocated(int new_size) {
	if(own_data) {
		if(size >= new_size)
			return;
		size += new_size;

		int mod = size % STRING_GRANULARITY;

		if(mod)
			size += STRING_GRANULARITY - mod;

		data = (char *)realloc(data, size);
	} else
		g_CLog.Log(LOG_SYSTEM, "EnsureAllocated: Tried to resize CString without local storage\n");
}