#pragma once
#include "gamesys.h"
#include <string.h>
#include <stdlib.h>

#include <stdio.h> // used for Save / Load

//TODO: Could reuse vector code

#define STRING_GRANULARITY	32
#define STRING_HASH_SIZE	8
#define STRING_HASH_BASE	(STRING_HASH_SIZE-1)


class CString {
public:
			CString();
			CString(bool own_data);
			CString(char *cdata, bool own_data = true);
			CString(char *cdata, int length, bool own_data = true);
			CString(CString &cstr, bool own_data = true);
			~CString();

	char&	operator[](int i);
	//char*	operator&();
	CString	operator+(CString &cstr);
	void	operator+=(CString &cstr);
	bool	operator==(CString &cstr);
	bool	operator!=(CString &cstr);
	CString& operator=(CString &cstr);
	CString& operator=(char* cdata);
	bool	operator==(char* cstr);
	bool	operator!=(char* cstr);

	void	StripQuotes();
	void	SetSize(int size);
	void	SetLen(int length);
	void	Append(char c);
	void	Append(char *str);
	void	Append(char *str, int str_len);
	void	Append(CString &cstr);
	void	Prepend(CString &cstr);
	int		ToFloat(float *ar, int n);
	char*	GetData();

	void	FixPath();
	void	RemoveExtension();

	int		Size();
	int		Length();
	int		GetNum();
	int		Hash();

	bool	Save(FILE *fp);
	void	Load(FILE *fp, int num);

private:
	void	EnsureAllocated(int new_size);

	char	*data;
	int		size;
	int		len;	// excluding '\0'
	const bool 
			own_data;
};

inline bool CString::Save(FILE *fp) {
	if(fwrite(data, sizeof(char), len, fp) != len) {
		return 1;
	}
	return 0;
}

inline void CString::Load(FILE *fp, int n) {
	EnsureAllocated(n);
	len = (int)fread(data, sizeof(char), n, fp);
	data[len] = 0;
};

inline int CString::GetNum() {
	return len;
}

inline int CString::Length() {
	return len;
}

inline CString::CString():len(0),size(0),data(NULL),own_data(1) {};

inline CString::CString(bool owndata):len(0),size(0),data(NULL),own_data(owndata) {};

inline CString::CString(char *cdata, bool owndata):own_data(owndata) {
	len = (int)strlen(cdata);
	size = len + 1;
	if(own_data) {
		data = new char [size];
		memcpy(data, cdata, size);
	} else {
		data = cdata;
	}
}

inline CString::CString(char *cdata, int length, bool owndata):own_data(owndata) {
	len = length;
	size = len + 1;
	if(own_data) {
		data = new char [size];
		memcpy(data, cdata, len);
	} else {
		data = cdata;
	}
}

inline CString::CString(CString &cdata, bool owndata):own_data(owndata) {
	len = cdata.len;
	size = len + 1;
	if(own_data) {
		data = new char [size];
		memcpy(data, cdata.data, size);
	} else {
		data = cdata.data;
	}
}

inline CString::~CString() {
	if(own_data && data)
		delete [] data;
}

inline char& CString::operator[](int i) {
	return data[i];
}

inline char* CString::GetData() {
	return data;
}

inline CString CString::operator+(CString &cstr) {
	CString result(*this);
	result.Append(cstr);
	return result;
}

inline void CString::operator+=(CString &cstr) {
	Append(cstr);
}

inline bool CString::operator==(CString &cstr) {
	if(len == cstr.len)
		return !strncmp(data, cstr.data, len);
	else
		return false;
}

inline bool CString::operator==(char *cstr) {
	if(!len)
		return false;
	else
		return !strncmp(data, cstr, len);
}

#pragma warning (disable:4800)
inline bool CString::operator!=(char *cstr) {
	if(!len)
		return true;
	else
		return (bool)strncmp(data, cstr, size);
}

inline bool CString::operator!=(CString &cstr) {
	if(len == cstr.len)
		return (bool)strncmp(data, cstr.data, len);
	else
		return true;
}
#pragma warning (default:4800)


inline CString& CString::operator=(CString &cstr) {
	len = cstr.len;
	if(own_data) {
		EnsureAllocated(len + 1);
		memcpy(data, cstr.data, size);
	} else {
		data = cstr.data;
	}
	return *this;
}


inline CString& CString::operator=(char* cdata) {
	len = (int)strlen(cdata);
	if(own_data) {
		EnsureAllocated(len + 1);
		memcpy(data, cdata, size);
	} else {
		data = cdata;
	}
	return *this;
}

inline void CString::SetSize(int size) {
	EnsureAllocated(size);
}

inline void CString::SetLen(int length) {
	EnsureAllocated(length+1);
	len = length;
}

inline void CString::Append(CString &cstr) {
	EnsureAllocated(cstr.len + len + 1);
	memcpy(data+len, cstr.data, cstr.len + 1);
	len += cstr.len;
}

inline void CString::Prepend(CString &cstr) {
	EnsureAllocated(cstr.len + len + 1);
	memcpy(data+cstr.len, data, len + 1);
	memcpy(data, cstr.data, cstr.len);
	len += cstr.len;
}

inline void CString::Append(char *str, int str_len) {
	if(str_len <= 0)
		return;

	EnsureAllocated(len + str_len + 1);
	memcpy(data+len, str, str_len);
	len += str_len;
	data[len] = 0;
}

inline void CString::Append(char *str) {
	int str_len = (int)strlen(str);

	EnsureAllocated(len + str_len-1);
	memcpy(data+len, str, str_len);
	len += str_len;
}

inline void CString::Append(char c) {
	EnsureAllocated(len + 2);
	data[len] = c;
	data[++len] = 0;
}

inline int CString::Size() {
	return size;
}

inline int CString::ToFloat(float *ar, int n) {
	int r = 0;
	
	if(!data || data[0] == 0 || data[0] == '\n' || !n)
		return 0;

	for(int i=0; i<len; i++) {

		ar[r++] = (float)atof(data+i);

		if(r == n)
			break;

		while(data[i] != ' ' && data[i] != '\t') {
			if(data[i] == 0 || data[i] == '\n')
				break;
			i++;
		}
	}

	return r;
}

inline void CString::FixPath() {
	for(int i=0; i<len; i++)
		if(data[i] == '/')
			data[i] = '\\';
}

inline void CString::RemoveExtension() {
	for(int i=len-1; i>=0; i--)
		if(data[i] == '.') {
			len = i;
			data[i] = 0;
			return;
		}
}

inline void CString::StripQuotes() {
	if(data[0] != '\"' || data[len-1] != '\"')
		return;
	for(int i=0; i<len-1; i++) {
		data[i] = data[i+1];
	}
	len -= 2;
	data[len] = 0;
}