#include "bspconv.h"
#include "bspbrush.h"

_CBSPLeafNode *CreateSubmodel(CMapEntity* entity) {
	CVector<CMapBrush> *brushes = entity->GetBrushes();

	if (!brushes->GetNum()) {
		return 0;
	}

	_CBSPLeafNode *leaf = new _CBSPLeafNode;
	leaf->brushes.TailAlloc(brushes->GetNum());

	leaf->min = vec4( WORLD_SIZE,  WORLD_SIZE,  WORLD_SIZE);
	leaf->max = vec4(-WORLD_SIZE, -WORLD_SIZE, -WORLD_SIZE);

	for(int i=0; i<brushes->GetNum(); i++) {
		leaf->brushes[i] = new _CBSPBrush;

		_CBSPBrush *brush = leaf->brushes[i];

		brush->BuildBrush( &brushes->GetElemNoBCheck(i) );

		leaf->faces.Append( brush->faces );

		for(int i=0; i<brush->faces.GetNum(); i++) {
			CAlignedVec<vec4> *p = brush->faces[i]->winding.GetPoints();

			for(int j=0; j<p->GetNum(); j++) {
				leaf->min.minSelf( p->GetElemNoBCheck(j) );
				leaf->max.maxSelf( p->GetElemNoBCheck(j) );
			}
		}
	}

	g_CLog.Log(LOG_SYSTEM, "%4d faces on submodel.", leaf->faces.GetNum());

	return leaf;
}