#pragma once

/*
	This file is part of rmapc - a fast BSP map compiler.

    Copyright (C) 2008 Rouslan Dimitrov

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "math.h"
#include "thread.h"
#include "bitstring.h"
#include "bsp.h"
#include "string.h"
#include "winding.h"
#include "vector.h"
#include "vectoraligned.h"
#include "stack.h"
#include "portaldata.h"

struct sCluster {
	CVector<int>	portals;
	CBitString		visibility;
};

struct sVisPortal {
	int			cluster;
	int			otherCluster;	// cluster this portal points to

	CWinding*	winding;
	sPlane		plane;
	
	CBitString	vInfront;	// Pass 1
	CBitString	vVisible;	// Pass 3
	CBitString	vFlood;		// Pass 2
};

struct sVisFlowData {
	CWinding	winding;	// winding at destination portal
	sVisPortal*	portal;		// portal currently considered
};

typedef CStack<sVisFlowData, CAlignedVec<sVisFlowData> > VFStack;

struct sVisFlow {
	sVisPortal*	sPortal;	// start portal
	sVisPortal*	ePortal;	// end portal
	VFStack		stack;		// stack of portals in between
	CBitString	visitedClusters;

	int			MEPI;		// Mirrored End Portal Index
	bool		reverseSPW;	// half of the source portals have reversed windings
};

enum {
	VF_VISIBLE,
	VF_HIDDEN
};

// TODO: The pass redirectors are a quick hack :)

class CVisCalc {
public:
			CVisCalc();
			~CVisCalc();

	bool	LoadBSP(char* filename);
	void	SaveBSP();

	void	DoVis();
private:
	// Pass 1
	friend
	void	Pass1Redirector(int p, void *visCalc);

	void	Pass1(int portal);
	void	ComputeInfront(sVisPortal *Portal);

	// Pass 2
	friend
	void	Pass2Redirector(int p, void *visCalc);

	void	Pass2(int portal);
	void	FrontFlood(CStack<sVisPortal*>&  sInFront, int iCluster);

	// Pass 3
	friend
	void	Pass3Redirector(int c, void *visCalc);

	void	Pass3(int cluster);
	int		VisFlow(sVisFlow *vf);

	void	TrimPassage(CWinding *src, bool bFilpSrc, CWinding *mid, CWinding *dst, CWinding *ret);
	inline
	int		MirrorPortalIndex(int i);
	
	// Pass 4
	friend
	void Pass4Redirector(int c, void *visCalc);

	void	Pass4(int cluster);

	CAlignedVec<sVisPortal> portals;
	CVector<sCluster>	clusters;

	CThreadPool			threads;
	CString				filename;
};