#include "bsp.h"

#include <stdio.h>
#include "log.h"

#define SaveLump(lump, data) 	header.lumps[lump].offset = ftell(fp);	\
								data.Save(fp)?g_CLog.Log(LOG_SYSTEM, LOG_FILE_WRITE_ERROR, filename):0;			\
								header.lumps[lump].length = data.GetNum()*sizeof(data[0]);

#define LoadLump(lump, data) 	fseek(fp, header.lumps[lump].offset, SEEK_SET); data.Load(fp, header.lumps[lump].length / sizeof(data[0]));			\


void CBSP::Save(char *filename) {
	FILE *fp = fopen(filename, "wb");
	if(fp) {
		g_CLog.Log(LOG_SYSTEM, "Saving to %s.", filename);
	} else {
		g_CLog.Log(LOG_SYSTEM, "Couldn't open %s for writing.", filename);
		return;
	}

	sBSPHeader header;
	header.ID = BSP_ID.iBSP_ID;
	header.version = BSP_VER;

	fwrite(&header, sizeof(sBSPHeader), 1, fp);

	SaveLump(kEntities, entities);
	SaveLump(kShaders, shaders);
	SaveLump(kPlanes, planes);
	SaveLump(kNodes, nodes);
	SaveLump(kLeafs, leafs);
	SaveLump(kLeafSurfaces, leafSurfIndex);
	SaveLump(kLeafBrushes, leafBrushIndex);
	SaveLump(kModels, models);
	SaveLump(kBrushes, brushes);
	SaveLump(kBrushSides, brushSides);
	SaveLump(kVertices, vertices);
	SaveLump(kIndices, vertexIndicies);
	SaveLump(kFogs, fogs);
	SaveLump(kSurfaces, surfaces);
	SaveLump(kLightmaps, lightMaps);
	SaveLump(kLightVolumes, lightGrid);
	SaveLump(kVisData, visibility);

	rewind(fp);
	fwrite(&header, sizeof(sBSPHeader), 1, fp);

	fclose(fp);
}

bool CBSP::Load(char *filename) {
	FILE *fp = fopen(filename, "rb");
	if(!fp) {
		g_CLog.Log(LOG_SYSTEM, LOG_FILE_NOT_FOUND, filename);
		return false;
	}

	sBSPHeader header;
	fread(&header, sizeof(sBSPHeader), 1, fp);

	if(header.ID != BSP_ID.iBSP_ID) {
		g_CLog.Log(LOG_SYSTEM, "File %s is not a valid BSP File.", filename);
		return false;
	}
	
	if(header.version != BSP_VER) {
		g_CLog.Log(LOG_SYSTEM, "File %s is wrong version - expected %d, got %d.", filename, BSP_VER, header.version);
		return false;
	}

	LoadLump(kEntities, entities);
	LoadLump(kShaders, shaders);
	LoadLump(kPlanes, planes);
	LoadLump(kNodes, nodes);
	LoadLump(kLeafs, leafs);
	LoadLump(kLeafSurfaces, leafSurfIndex);
	LoadLump(kLeafBrushes, leafBrushIndex);
	LoadLump(kModels, models);
	LoadLump(kBrushes, brushes);
	LoadLump(kBrushSides, brushSides);
	LoadLump(kVertices, vertices);
	LoadLump(kIndices, vertexIndicies);
	LoadLump(kFogs, fogs);
	LoadLump(kSurfaces, surfaces);
	LoadLump(kLightmaps, lightMaps);
	LoadLump(kLightVolumes, lightGrid);
	LoadLump(kVisData, visibility);

	fclose(fp);

	return true;
}