#pragma once

#include "vector.h"
#include "vectoraligned.h"
#include "math.h"

union uBSPID {
	char	cBSP_ID[4];
	int		iBSP_ID;
};

const uBSPID	BSP_ID = {'I', 'B', 'S', 'P'};
const int		BSP_VER = 46;

#define BSP_FILENAME_LEN 64

struct vec2f {
	vec2f operator=(vec4& v) {
		x = v.x;
		y = v.y;
		return *this;
	}

	float x, y;
};

struct vec3f {
	vec3f operator=(vec4& v) {
		x = v.x;
		y = v.y;
		z = v.z;
		return *this;
	}

	float x, y, z;
};

struct vec2i {
	vec2i operator=(vec4& v) {
		x = (int)v.x;
		y = (int)v.y;
		return *this;
	}
	int x, y;
};

struct vec3i {
	vec3i operator=(vec4& v) {
		x = (int)v.x;
		y = (int)v.y;
		z = (int)v.z;
		return *this;
	}
	union {
		struct {
			int x, y, z;
		};
		int data[3];
	};
};

struct sBSPShader{
	char	shader[BSP_FILENAME_LEN];
	int		surfaceFlags;
	int		contentFlags;
};

struct sBSPColor {
	char r,g,b;
};

struct sBSPFog{
	char	shader[BSP_FILENAME_LEN];
	int		brushNum;
	int		visibleSide;
};

// Vertex
struct sBSPVertex{
	vec3f			pos;
	vec2f			tex_coord;
	vec2f			lm_coord;
	vec3f			normal;
	unsigned char	color[4];
};

// Surface
enum eSurfaceType {
	kBad,
	kPlanar,
	kPatch,
	kTriangles,
	kSprite
};

struct sBSPSurface {
	int		shaderNum;
	int		fogNum;
	int		surfaceType;

	int		firstVert;
	int		numVerts;

	int		firstIndex;
	int		numIndexes;

	int		lightmapNum;
	vec2i	lightmapCorner;
	vec2i	lightmapSize;
	vec3f	lightmapOrigin;
	vec3f	lightmapVecs[2];
	
	vec3f	normal;

	vec2i	patchSize;
};

struct sBSPBrushSide {
	int plane;
	int shaderNum;
};

struct sBSPBrush {
	int	firstSide;
	int	numSides;
	int	shaderNum;
};

// BSP
struct sBSPNode {
	int		planeNum;
	int		children[2];
	vec3i	mins;
	vec3i	maxs;
};

struct sBSPLeaf {
	int		cluster;
	int		area;

	vec3i	mins;
	vec3i	maxs;

	int		firstLeafSurface;
	int		numLeafSurfaces;

	int		firstLeafBrush;
	int		numLeafBrushes;
};

struct sBSPModel {
	vec3f	min;
	vec3f	max;
	int		firstSurface;
	int		numSurfaces;
	int		firstBrush;
	int		numBrushes;
};

// vis
struct sBSPVisibilityHeader
{
	int				numClusters;
	int				bytesPerCluster;
};

// file

enum eLumps
{
    kEntities,
    kShaders,
    kPlanes,
    kNodes,	
    kLeafs,
    kLeafSurfaces,
    kLeafBrushes,
    kModels,
    kBrushes,
    kBrushSides,
    kVertices,
    kIndices,
    kFogs,
    kSurfaces,
    kLightmaps,
    kLightVolumes,
    kVisData,
    kMaxLumps
};

struct sBSPLump {
	int		offset;
	int		length;
};

struct sBSPHeader {
	int		ID;
	int		version;

	sBSPLump lumps[kMaxLumps];
};



