#pragma once

template <class type>
class CList {
public:
	struct node {
				node(type& d, node *n): data(d), next(n) {};
		type	data;
		node	*next;
	};
			CList();
			~CList();
	void	PushFront(type t);
	type*	PopFront();
	type*	PeekFront();
	void	Clear();
	void	ClearData();
private:
	node	*head;
};


template <class type>
inline CList<type>::CList(): head(0) {};

template <class type>
inline CList<type>::~CList() {
	Clear();
}

template <class type>
inline void CList<type>::PushFront(type t) {
	node *n = new node(t, head);
	head = n;
}

template <class type>
inline type* CList<type>::PeekFront() {
	return head->data;
}

template <class type>
inline type* CList<type>::PopFront() {
	type *r = head->data;
	node *popped = head;
	head = head->next;
	delete popped;
	return r;
}

template <class type>
inline void CList<type>::Clear() {
	node *n = head;
	while(n) {
		node *cur = n;
		n = n->next;
		delete cur;
	}
	head = 0;
}

template <class type>
inline void CList<type>::ClearData() {
	node *n = head;
	while(n) {
		node *cur = n;
		n = n->next;
		delete cur->data;
		delete cur;
	}
	head = 0;
}
	