#include "map.h"
#include "bspconv.h"
#include "log.h"
#include "string.h"

int main(int argc, char **argv) {
	g_CLog.Log(LOG_SYSTEM, LOG_APP_INIT, NULL);

	if(argc != 2) {
		g_CLog.Log(LOG_SYSTEM, "Usage: rmapc [filename]");
		return 0;
	}

	CMapLoader		map;
	CBSP			bsp;
	CString			file(argv[1]);

	if(map.LoadMap(&file)) {
		if(CompileMap(&bsp, &map)) {
			file.RemoveExtension();
			file.Append(".bsp");
			bsp.Save(file.GetData());
			return R_OK;
		}
	}

	return R_FAIL;
}