#pragma once

#include "hashtablevec.h"
#include "lexer.h"
#include "string.h"
#include "vector.h"
#include "math.h"
#include "keyvalpair.h"
#include "shader.h"

class CMapBrush;

class CMapEntity {
public:
	CVector<CMapBrush>*	GetBrushes();
	CString*			GetValue(CString& key);
	void				EmitKVPairs(CString *str);

	bool				Parse();

	CDict				keyValPairs;
	CVector<CMapBrush>	brushes;
};

inline CVector<CMapBrush>* CMapEntity::GetBrushes() {
	return &brushes;
}

inline CString* CMapEntity::GetValue(CString& key) {
	return keyValPairs.Get(key);
}

class CMapLoader {
public:
							CMapLoader();
							~CMapLoader();
	bool					LoadMap(CString *filename);
	int						AddPlane(sPlane& p);
	int						AddShader(CMapShader& s);
	sPlane*					GetPlane(int i);
	CMapShader*				GetShader(int i);
	CVector<CMapEntity>*	GetEntities();
	CLexer*					GetLex();
	CString*				GetFilename();

private:
	CVector<CMapEntity>		entities;
	CVecHash<sPlane>		planes;
	CVecHash<CMapShader>	shaders;

	CLexer					lex;
	CString					src;
	CString*				filename;
};

// While a mediator object might be a more elegant solution
// than a global map pointer, here it seems it will be slower
// and harder to understand.
extern CMapLoader	*g_curMap;

inline CMapLoader::CMapLoader():src(true) {
}

inline CMapLoader::~CMapLoader() {
	if(g_curMap == this)
		g_curMap = 0;
}

inline CString* CMapLoader::GetFilename() {
	return filename;
}

inline CVector<CMapEntity>* CMapLoader::GetEntities() {
	return &entities;
}

inline int CMapLoader::AddPlane(sPlane& p) {
	return planes.AddElem(p);
}

inline sPlane* CMapLoader::GetPlane(int i) {
	return planes.GetElem(i);
}

inline int CMapLoader::AddShader(CMapShader& s) {
	return shaders.AddElem(s);
}

inline CMapShader* CMapLoader::GetShader(int i) {
	return shaders.GetElem(i);
}

inline CLexer* CMapLoader::GetLex() {
	return &lex;
}

