#pragma once

#include "bspconv.h"
#include "portaldata.h"

#define BINARY_PORTAL_FILE

struct sPortal {
	CWinding	winding;
	_CBSPNode*	nodes[2];
	int			plane;
};

class CPortalBuilder : public IBSPTreeVisitor {
public:
	// visitor interface
	void				VisitNodeBegin(_CBSPSplitNode *n);
	void				VisitNodeEnd(_CBSPSplitNode *n) {};
	void				VisitLeaf(_CBSPLeafNode *l) {};

	// public interface
	void				BuildPortals(_CBSPTree *tree);
	void				RebuildPortals();
	void				MarkNodeReachability();
	bool				IsMapClosed();
	void				CalcBounds();
	void				SaveToFile(char *filename);
	CVector<sPortal>*	GetPortals();
private:
	void				CreateNodePortal(_CBSPSplitNode *node);
	void				SplitNodePortals(_CBSPSplitNode *node);
	void				CreateHeadPortals();
	
	void				FloodReachability(_CBSPLeafNode *leaf);

	void				RemovePortalReference(_CBSPNode *n, int portal);

	CVector<sPortal>	portals;
	_CBSPLeafNode		outside;	// virtual leaf, outside map
	_CBSPTree			*tree;
	int					nLeafs;
};

inline void CPortalBuilder::RebuildPortals() {
	outside.portals.Clear();
	outside.flags = NODE_OPAQUE;
	portals.Clear();
	BuildPortals(tree);
}

inline void CPortalBuilder::VisitNodeBegin(_CBSPSplitNode *n) {
	CreateNodePortal(n);
	SplitNodePortals(n);
}

inline CVector<sPortal>* CPortalBuilder::GetPortals() {
	return &portals;
}

class CNodeBoundsCalc : public IBSPTreeVisitor {
public:
	// visitor interface
	void	VisitNodeBegin(_CBSPSplitNode *n) {};
	void	VisitNodeEnd(_CBSPSplitNode *n);
	void	VisitLeaf(_CBSPLeafNode *l);

	void	CalcBounds(_CBSPTree *tree, CVector<sPortal>* portals);
private:
	CVector<sPortal>*	portals;
};

inline void CNodeBoundsCalc::CalcBounds(_CBSPTree *tree, CVector<sPortal>* p) {
	portals = p;
	tree->Traverse(this);
}

inline void CPortalBuilder::CalcBounds() {
	CNodeBoundsCalc bc;
	bc.CalcBounds(tree, &portals);
}


