#pragma once
#include "string.h"
#include "surfaceflags.h"

class CMapShader {
public:
			CMapShader();
			CMapShader(CString &name);
			CMapShader(bool has_name_storage);
	int		Hash();
	bool	operator==(CMapShader &shader);
	void	Load(CString &name);

	CString	name;
	int		surfaceFlags;
	int		contentFlags;

	int		textureWidth;
	int		textureHeight;
};

inline CMapShader::CMapShader():
surfaceFlags(0),
contentFlags(CONTENTS_SOLID),
textureWidth(256),
textureHeight(256){
}

inline CMapShader::CMapShader(bool has_name_storage):name(has_name_storage),surfaceFlags(0), contentFlags(CONTENTS_SOLID) {
}

inline int CMapShader::Hash() {
	return name.Hash();
}

inline bool	CMapShader::operator==(CMapShader &s) {
	return	(surfaceFlags == s.surfaceFlags) &&
			(contentFlags == s.contentFlags) &&
			(name == s.name);
}

// Stubs!

inline CMapShader::CMapShader(CString &n):
surfaceFlags(0),
contentFlags(CONTENTS_SOLID),
textureWidth(256),
textureHeight(256),
name(n){
}

inline void	CMapShader::Load(CString &n) {
	name = n;
}