#pragma once

#include <queue>
#include "vector.h"

template <class T, class STORAGE = CVector<T> >
class CStack {
public:
	void	Push(T* elem);
	T*		PushPeek();
	T*		PeekTop();
	T*		Pop();
	void	Clear();

	T&		operator[](int i);
	int		GetNum();
private:
	STORAGE data;
};

template <class T, class S>
inline void CStack<T, S>::Push(T* elem) {
	T& e = data.TailAlloc();
	e = *elem;
}

template <class T, class S>
inline T* CStack<T, S>::PushPeek() {
	T& e = data.TailAlloc();
	return &e;
}

template <class T, class S>
inline T* CStack<T, S>::PeekTop() {
	return &data[data.GetNum() - 1];
}

template <class T, class S>
inline T* CStack<T, S>::Pop() {
	data.SetNum(data.GetNum() - 1);
	return &data[data.GetNum()];
}

template <class T, class S>
inline T& CStack<T, S>::operator[](int i) {
	return data[i];
}

template <class T, class S>
inline int CStack<T, S>::GetNum() {
	return data.GetNum();
}

template <class T, class S>
inline void CStack<T, S>::Clear() {
	data.SetNum(0);
}

