#include "visibility.h"
#include "log.h"
#include "string.h"

int main(int argc, char **argv) {
	g_CLog.Log(LOG_SYSTEM, "rvisc start up");

	if(argc != 2) {
		g_CLog.Log(LOG_SYSTEM, "Usage: rvisc [filename]");
		return 0;
	}

	CVisCalc visCalc;

	if(visCalc.LoadBSP(argv[1])) {
		LARGE_INTEGER TimerFreq;
		LARGE_INTEGER startTicks, endTicks;  

		if(QueryPerformanceFrequency(&TimerFreq)) {
			QueryPerformanceCounter(&startTicks);

			visCalc.DoVis();

			QueryPerformanceCounter(&endTicks);
			g_CLog.Log(LOG_SYSTEM, "Visibility computation took %f seconds.",
				(float)(endTicks.QuadPart - startTicks.QuadPart)/(float)TimerFreq.QuadPart);
			
			
		}else {
			g_CLog.Log(LOG_SYSTEM, "No Precision timer available");

			visCalc.DoVis();
		}
		visCalc.SaveBSP();
	}		

	return 0;
	
}