/*
	This file is part of rmapc - a fast BSP map compiler.

    Copyright (C) 2008 Rouslan Dimitrov

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once
#include "memalloc.h"
#include "gamesys.h"
#include "math.h"
#include "vectoraligned.h"

#define MAX_WINDING_POINTS 32

// Winding is right-handed (ccw)

class CWinding : public CMemObj {
public:
						CWinding();
						CWinding(CWinding *w);
						~CWinding(){};
						CWinding(sPlane *plane);
	void				AddPointToConvexHull(vec4 *point, sPlane *plane);
	void				AddWindingToConvexHull(CWinding *w);
	void				AddWindingToConvexHull(CWinding *w, sPlane *plane);
	void				CreateBaseWinding(sPlane *plane);
	void				ChopWinding(sPlane *plane);
	int					OnSide(sPlane *plane);
	void				OnSide(sPlane *plane, int *sides);
	void				SplitWinding(CWinding &front, vec4 *plane);
	CWinding&			operator=(CWinding& w);
	CAlignedVec<vec4>*	GetPoints();
	float				Area();	// signed area
	bool				Tiny();
	bool				Empty();
private:
	CAlignedVec<vec4>	points;
};

inline CWinding::CWinding(){} 

inline CWinding::CWinding(vec4 *plane) {
	CreateBaseWinding(plane);
}

inline bool CWinding::Tiny() {
	return Area() < 10.0f*EPSILON;
}

inline bool CWinding::Empty() {
	return !points.GetNum();
}

inline CAlignedVec<vec4>* CWinding::GetPoints() {
	return &points;
}

inline CWinding::CWinding(CWinding *w) {
	points = w->points;
#if 0
	points.Reserve(w->points.GetNum());
	points.SetNum(w->points.GetNum());
	for(int i=0; i<points.GetNum(); i++)
		points[i] = w->points[i];
#endif
}

inline CWinding& CWinding::operator=(CWinding& w) {
	points = w.points;
	return *this;
}